<h1 align="center" style="color:#292728F6;">
    🚀 PlayLab – Cross Platform Video Streaming Application Using Flutter
</h1>

[![PlayLab on CodeCanyon](https://img.shields.io/badge/Available%20on-CodeCanyon-green)](https://codecanyon.net/item/playlab-cross-platform-on-demand-movie-streaming-mobile-application/38767082?s_rank=1)

### Team Overview
<table>
    <tr>
        <td align="center" valign="top" width="160">
            <img src="https://avatars.githubusercontent.com/u/46804139?v=4" width="60" alt="NM Kawcher" style="border-radius:50%"><br/>
            <b>NM Kawcher</b><br/>
            <img src="https://img.shields.io/badge/-Mobile%20Developer-blue?style=flat-square&logo=github" alt="Mobile Developer"/><br/>
            <a href="https://github.com/nmkawcher">
                <img src="https://img.shields.io/badge/GitHub-Profile-black?logo=github&style=flat-square" alt="GitHub"/>
            </a>
        </td>
        <td align="center" valign="top" width="160">
            <img src="https://avatars.githubusercontent.com/u/64397792?s=400&u=0babcad5dd54e9af6fbac2c75138e02bec88a8a2&v=4" width="60" alt="Hossain al Jim" style="border-radius:50%"><br/>
            <b>Hossain al Jim</b><br/>
            <img src="https://img.shields.io/badge/-Mobile%20Developer-blue?style=flat-square&logo=github" alt="Mobile Developer"/><br/>
            <a href="https://github.com/jim-2000">
                <img src="https://img.shields.io/badge/GitHub-Profile-black?logo=github&style=flat-square" alt="GitHub"/>
            </a>
        </td>
    </tr>
</table>
<table>
    <tr>
        <td align="center" valign="top" width="160">
            <img src="https://avatars.githubusercontent.com/u/67152205?v=4" width="60" alt="Md Atikur Rahman" style="border-radius:50%"><br/>
            <b>Md Atikur Rahman</b><br/>
            <img src="https://img.shields.io/badge/-Laravel%20Developer-red?style=flat-square&logo=laravel" alt="Laravel Developer"/><br/>
            <a href="https://github.com/atikur55">
                <img src="https://img.shields.io/badge/GitHub-Profile-black?logo=github&style=flat-square" alt="GitHub"/>
            </a>
        </td>
    </tr>
</table>

### 🔍 Project Overview
<blockquote style="color: gray; background-color: white; padding: 20px; border-radius: 4px;">

PlayLab is a comprehensive, feature-rich movie streaming platform that allows you to build your own on-demand service with ease. Offering seamless video playback, free and paid content, secure subscription options, 30+ payment gateways, and integration with Digital Ocean, Wasabi and FTP for storage, PlayLab is fully customizable. With a modern user interface, responsive design, multi-language support, and admin control features, it’s a perfect solution for creating a high-quality streaming service like Netflix or Prime Video.

</blockquote>

### ⏳ Project Timeline
<div align="center">

<table>
    <tr>
        <td align="center" style="background:#F6F8FA; border-radius:18px; padding:16px 24px;">
            <span style="font-size:1.2em; font-weight:bold;">📅 Project Timeline</span>
            <ul style="list-style:none; padding:0; margin:0;">
                <li>
                    <span style="color:#4CAF50; font-weight:bold;">🟢 Created:</span>
                    <span style="color:#333;">3 years ago</span>
                </li>
                <li>
                    <span style="color:#2196F3; font-weight:bold;">🔄 Last Updated:</span>
                    <span style="color:#333;">Today</span>
                </li>
            </ul>
        </td>
    </tr>
</table>

</div>
### ✨ Key Features

<ul>
    <li>
        <h3>🎬 Video Playback</h3>
        <p>Enjoy smooth and high-quality video playback with support for multiple formats and resolutions, ensuring the best viewing experience on any device.</p>
    </li>
    <li>
        <h3>📚 Content Management</h3>
        <p>Effortlessly organize, upload, and manage your video library with PlayLab's intuitive content management system.</p>
    </li>
    <li>
        <h3>💳 Subscription Plans</h3>
        <p>Monetize your platform by offering both free and premium content with secure subscription options for your users.</p>
    </li>
    <li>
        <h3>🌐 Payment Gateways</h3>
        <p>Seamless In-App Purchases (Android & iOS) and integration with 30+ external payment gateways for global reach.</p>
    </li>
    <li>
        <h3>📺 Live Reels</h3>
        <p>Engage your audience with real-time live reels, allowing users to watch and interact with trending short videos instantly.</p>
    </li>
    <li>
        <h3>🔎 Sort & Filter Videos</h3>
        <p>Help users discover content faster with advanced sorting and filtering options by genre, release date, popularity, and more.</p>
    </li>
    <li>
        <h3>🌍 Multi-Language Support</h3>
        <p>Reach a global audience with built-in multi-language support for both the app and admin panel.</p>
    </li>
    <li>
        <h3>🔒 Secure & Scalable</h3>
        <p>Robust security features and scalable architecture, including integration with Digital Ocean, Wasabi, and FTP for flexible storage solutions.</p>
    </li>
    <li>
        <h3>🖥️ Modern UI & Responsive Design</h3>
        <p>Delight users with a sleek, modern interface that looks great on any device, from mobile phones to tablets.</p>
    </li>
    <li>
        <h3>🛠️ Powerful Admin Controls</h3>
        <p>Comprehensive admin dashboard for managing users, content, subscriptions, and analytics with ease.</p>
    </li>
</ul>
 
### Screenshots

<div align="center">

<!-- Responsive screenshots grid -->
<style>
.screenshots-grid {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 16px;
}
.screenshots-grid img {
    width: 250px;
    max-width: 90vw;
    margin-bottom: 16px;
    border-radius: 8px;
}
@media (max-width: 600px) {
    .screenshots-grid {
        flex-direction: column;
        align-items: center;
    }
}
</style>

<div class="screenshots-grid">
    <img src="doc/img_1.png" alt="Home Screen" />
    <img src="doc/img_2.png" alt="All Movies Screen" />
    <img src="doc/img_3.png" alt="Tournament Screen" />
    <img src="doc/img_4.png" alt="Reels Screen" />
    <img src="doc/img_5.png" alt="Watch History" />
    <img src="doc/img_6.png" alt="Item Requests" />
</div>
<br>
</div>

### Banner
<div align="center">
    <img src="https://camo.envatousercontent.com/a434684ba46ee424af7d02f814824f1a2b09a830/68747470733a2f2f7363726970742e76697365726c61622e636f6d2f706c61796c61622f65787472612f666c75747465725f646573635f32322e706e67" alt="PlayLab Banner" style="max-width:100%; height:auto; border-radius:12px; margin-top:24px;">
</div>

---

## 📄 Copyright

&copy; 20243 [ViserLab](https://viserlab.com). All rights reserved.  
Unauthorized copying, distribution, or use of this project is strictly prohibited.

 